// controllers/consultaController.js
const db = require('../db/connection');

exports.getPersona = async (req, res) => {
    const { documento } = req.params;
    try {
        const [rows] = await db.query(
            'SELECT nombres, apellidos, edad, sexo, categoria FROM personas WHERE documento = ?',
            [documento]
        );
        if (rows.length === 0) return res.status(404).json({ error: 'Usuario no registrado o afiliado a Comfacasanare' });
        res.json(rows[0]);
    } catch (error) {
        res.status(500).json({ error: 'Error de servidor' });
    }
};